<?php

declare(strict_types=1);

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/helpers.php';

setupCors();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['message' => 'Method not allowed'], 405);
}

$pdo = db();
$body = readJsonBody();
$email = trim((string)($body['email'] ?? ''));
$password = (string)($body['password'] ?? '');

if ($email === '' || $password === '') {
    jsonResponse(['message' => 'Email and password are required'], 422);
}

$stmt = $pdo->prepare('SELECT id, email, password_hash FROM admins WHERE email = :email LIMIT 1');
$stmt->execute([':email' => $email]);
$admin = $stmt->fetch();

if (!$admin || !password_verify($password, $admin['password_hash'])) {
    jsonResponse(['message' => 'Invalid credentials'], 401);
}

$token = bin2hex(random_bytes(32));
$expiresAt = gmdate('Y-m-d H:i:s', time() + TOKEN_TTL_SECONDS);

$insert = $pdo->prepare('INSERT INTO admin_tokens (admin_id, token, expires_at) VALUES (:admin_id, :token, :expires_at)');
$insert->execute([
    ':admin_id' => $admin['id'],
    ':token' => $token,
    ':expires_at' => $expiresAt,
]);

jsonResponse([
    'token' => $token,
    'admin' => [
        'id' => (int)$admin['id'],
        'email' => $admin['email'],
    ],
    'expires_at' => $expiresAt,
]);
