<?php

declare(strict_types=1);

require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/helpers.php';

setupCors();
$pdo = db();
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $stmt = $pdo->query('SELECT id, make, model, year, vin, mileage, price, location, status, title_status, damage_summary, description, image_url, created_at, updated_at
    FROM cars
    ORDER BY id DESC');
    $cars = $stmt->fetchAll();

    jsonResponse(['cars' => $cars]);
}

if ($method === 'POST') {
    requireAdmin($pdo);

    $request = parseCarWriteRequest($method);
    $body = $request['body'];
    $files = $request['files'];

    $coverUpload = getPreferredCoverUpload($files);
    $galleryUploads = getGalleryUploads($files);

    $payload = validateCreateCarPayload($body, $coverUpload !== null);
    $createdFiles = [];

    try {
        if ($coverUpload !== null) {
            $payload['image_url'] = materializeUploadedFile($coverUpload, $createdFiles);
        } else {
            $payload['image_url'] = materializeImageReference($payload['image_url'], $createdFiles);
        }

        $galleryImages = materializeImageReferenceList($payload['images'], $createdFiles);
        if ($galleryUploads !== []) {
            $galleryImages = array_merge($galleryImages, materializeUploadedImages($galleryUploads, $createdFiles));
        }

        $stmt = $pdo->prepare('INSERT INTO cars (make, model, year, vin, mileage, price, location, status, title_status, damage_summary, description, image_url, updated_at)
        VALUES (:make, :model, :year, :vin, :mileage, :price, :location, :status, :title_status, :damage_summary, :description, :image_url, :updated_at)');

        $pdo->beginTransaction();

        $stmt->execute([
            ':make' => $payload['make'],
            ':model' => $payload['model'],
            ':year' => $payload['year'],
            ':vin' => $payload['vin'],
            ':mileage' => $payload['mileage'],
            ':price' => $payload['price'],
            ':location' => $payload['location'],
            ':status' => $payload['status'],
            ':title_status' => $payload['title_status'],
            ':damage_summary' => $payload['damage_summary'],
            ':description' => $payload['description'],
            ':image_url' => $payload['image_url'],
            ':updated_at' => gmdate('Y-m-d H:i:s'),
        ]);

        $carId = (int)$pdo->lastInsertId();
        replaceCarImages($pdo, $carId, $galleryImages);

        $pdo->commit();
    } catch (RuntimeException $e) {
        if ($pdo->inTransaction()) {
            $pdo->rollBack();
        }

        deleteLocalImageFiles($createdFiles);
        jsonResponse([
            'message' => 'Validation failed',
            'errors' => ['images' => [$e->getMessage()]],
        ], 422);
    } catch (PDOException $e) {
        if ($pdo->inTransaction()) {
            $pdo->rollBack();
        }

        deleteLocalImageFiles($createdFiles);
        jsonResponse(['message' => 'Failed to create car: ' . $e->getMessage()], 400);
    }

    $car = fetchCar($pdo, $carId);
    jsonResponse(['car' => $car], 201);
}

jsonResponse(['message' => 'Method not allowed'], 405);
