<?php

declare(strict_types=1);

require_once __DIR__ . '/db.php';
require_once __DIR__ . '/helpers.php';

function requireAdmin(PDO $pdo): array
{
    $token = getBearerToken();
    if ($token === null || $token === '') {
        jsonResponse(['message' => 'Unauthorized'], 401);
    }

    $stmt = $pdo->prepare('SELECT t.admin_id, a.email
        FROM admin_tokens t
        INNER JOIN admins a ON a.id = t.admin_id
        WHERE t.token = :token AND t.expires_at > :now
        LIMIT 1');

    $stmt->execute([
        ':token' => $token,
        ':now' => gmdate('Y-m-d H:i:s'),
    ]);

    $admin = $stmt->fetch();
    if (!$admin) {
        jsonResponse(['message' => 'Unauthorized'], 401);
    }

    return $admin;
}
