# PHP API

This folder contains a lightweight PHP backend for the salvage car frontend.

## Run locally

From project root:

```bash
php -S localhost:8000
```

Frontend is configured to use `http://localhost:8000/api`.

## Default admin account

- Email: `admin@salvageyard.com`
- Password: `admin123`

## Image storage behavior

- Car images are stored as local files in `api/images`.
- DB stores relative paths (for example `images/car_abcd1234.jpeg`) in both:
  - `cars.image_url`
  - `car_images.url`
- On create/update, frontend can send image sources as:
  - remote URL (`https://...`)
  - data URL (`data:image/...;base64,...`)
  - existing local path (`images/...`)
- The backend downloads/decodes and saves files to `api/images`, then stores the relative path.

## Endpoints

- `POST /api/login.php` (admin login)
- `GET /api/cars.php` (public car list)
- `POST /api/cars.php` (admin create car)
- `GET /api/car.php?id={id}` (public car details)
- `PUT /api/car.php?id={id}` (admin update car)
- `PATCH /api/car.php?id={id}` (admin update car)
- `DELETE /api/car.php?id={id}` (admin delete car)

## Response shapes

### List response

`GET /api/cars.php`

```json
{
  "cars": [
    {
      "id": 1,
      "make": "Toyota",
      "model": "Camry",
      "year": 2018,
      "vin": "4T1B11HK6JU123456",
      "mileage": 84200,
      "price": 4900,
      "location": "Dallas, TX",
      "status": "Available",
      "title_status": "Salvage",
      "damage_summary": "Front bumper and hood damage",
      "description": "Runs and drives. Engine and transmission are in good condition.",
      "image_url": "images/car_abc123.jpeg",
      "created_at": "2026-02-23 09:00:00",
      "updated_at": "2026-02-23 09:00:00"
    }
  ]
}
```

### Detail response

`GET /api/car.php?id=1`

```json
{
  "car": {
    "id": 1,
    "make": "Toyota",
    "model": "Camry",
    "year": 2018,
    "vin": "4T1B11HK6JU123456",
    "mileage": 84200,
    "price": 4900,
    "location": "Dallas, TX",
    "status": "Available",
    "title_status": "Salvage",
    "damage_summary": "Front bumper and hood damage",
    "description": "Runs and drives. Engine and transmission are in good condition.",
    "image_url": "images/car_abc123.jpeg",
    "created_at": "2026-02-23 09:00:00",
    "updated_at": "2026-02-23 09:00:00",
    "images": [
      { "url": "images/car_def456.jpeg" },
      { "url": "images/car_ghi789.jpeg" }
    ]
  }
}
```

## Create/Update payload

`POST /api/cars.php`, `PUT/PATCH /api/car.php?id={id}`

```json
{
  "make": "Toyota",
  "model": "Camry",
  "year": 2018,
  "vin": "4T1B11HK6JU123456",
  "mileage": 84200,
  "price": 4900,
  "location": "Dallas, TX",
  "status": "Available",
  "title_status": "Salvage",
  "damage_summary": "Front bumper and hood damage",
  "description": "Runs and drives. Engine and transmission are in good condition.",
  "image_url": "https://images.unsplash.com/photo-1550355291-bbee04a92027?auto=format&fit=crop&w=1200&q=80",
  "images": [
    { "url": "https://images.unsplash.com/photo-1503376780353-7e6692767b70?auto=format&fit=crop&w=1200&q=80" },
    { "url": "https://images.unsplash.com/photo-1493238792000-8113da705763?auto=format&fit=crop&w=1200&q=80" }
  ]
}
```

Validation rules:
- `image_url`: required string; must be an image URL, data URL, or local `images/...` path.
- `images`: optional array; when present, each item must be an object with required `url` value using the same accepted formats.
- Validation failures return HTTP `422` with an `errors` object.

## Notes

- Uses SQLite (`api/database.sqlite`) and auto-initializes on first request.
- Admin auth uses bearer tokens stored in `admin_tokens`.
- Seed data pulls Unsplash images into local files in `api/images` (falls back to `images/default-placeholder.jpeg` if remote download fails).
